(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     34856,        808]
NotebookOptionsPosition[     34379,        787]
NotebookOutlinePosition[     34721,        802]
CellTagsIndexPosition[     34678,        799]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Free Induction Decay (Imaginary part)\>\"", ",", "\"\<Label\>\"", 
        ",", " ", "12", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"Amplitude1", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]1", "*", "Pi", "*", "I"}], "-", 
               RowBox[{"0.2", "*", "\[Lambda]1"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}], "+", 
          RowBox[{"Amplitude2", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]2", "*", "5", "*", "Pi", "*", "I"}], "-", 
               RowBox[{"0.2", "*", "\[Lambda]2"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}], "+", 
          RowBox[{"Amplitude3", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]3", "*", 
                RowBox[{"-", "5"}], "*", "Pi", "*", "I"}], "-", 
               RowBox[{"2", "*", "0.2", "*", "\[Lambda]3"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}], "+", 
          RowBox[{"Amplitude4", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]4", "*", 
                RowBox[{"-", "0.5"}], "Pi", "*", "I"}], "-", 
               RowBox[{"0.2", "*", "\[Lambda]4"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Time (s)\>\"", ",", "10", ",", "Italic"}], "]"}]}], 
        ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"330", ",", "200"}], "}"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Free Induction Decay (Real part)\>\"", ",", "\"\<Label\>\"", ",", 
        " ", "12", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"Amplitude1", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]1", "*", "Pi", "*", "I"}], "-", 
               RowBox[{"0.2", "*", "\[Lambda]1"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}], "+", 
          RowBox[{"Amplitude2", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]2", "*", "5", "*", "Pi", "*", "I"}], "-", 
               RowBox[{"0.2", "*", "\[Lambda]2"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}], "+", 
          RowBox[{"Amplitude3", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]3", "*", 
                RowBox[{"-", "5"}], "*", "Pi", "*", "I"}], "-", 
               RowBox[{"2", "*", "0.2", "*", "\[Lambda]3"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}], "+", 
          RowBox[{"Amplitude4", "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Omega]4", "*", 
                RowBox[{"-", "0.5"}], "Pi", "*", "I"}], "-", 
               RowBox[{"0.2", "*", "\[Lambda]4"}], "-", 
               RowBox[{"I", "*", "\[Phi]"}]}], ")"}], "t"}], "]"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Time (s)\>\"", ",", "10", ",", "Italic"}], "]"}]}], 
        ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"330", ",", "200"}], "}"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<NMR Spectrum (Imaginary part)\>\"", ",", "\"\<Label\>\"", ",", 
        " ", "12", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Amplitude1", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"0.2", "*", "\[Lambda]1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]1"}], ")"}], "*", "Pi", "*",
                "I"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Amplitude2", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]2"}], ")"}], "*", "5", "*", 
               "Pi", "*", "I"}], "+", 
              RowBox[{"0.2", "*", "\[Lambda]2"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Amplitude3", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]3"}], ")"}], "*", 
               RowBox[{"-", "5"}], "*", "Pi", "*", "I"}], "+", 
              RowBox[{"0.4", "*", "\[Lambda]3"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Amplitude4", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]4"}], ")"}], "*", 
               RowBox[{"-", "0.5"}], "Pi", "*", "I"}], "+", 
              RowBox[{"0.2", "*", "\[Lambda]4"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Omega]", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Frequency (Hz)\>\"", ",", "10", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"330", ",", "200"}], "}"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<NMR Spectrum (Real part)\>\"", ",", "\"\<Label\>\"", ",", " ", 
        "12", ",", "Bold"}], "]"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Amplitude1", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"0.2", "*", "\[Lambda]1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]1"}], ")"}], "*", "Pi", "*",
                "I"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Amplitude2", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]2"}], ")"}], "*", "5", "*", 
               "Pi", "*", "I"}], "+", 
              RowBox[{"0.2", "*", "\[Lambda]2"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Amplitude3", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]3"}], ")"}], "*", 
               RowBox[{"-", "5"}], "*", "Pi", "*", "I"}], "+", 
              RowBox[{"0.4", "*", "\[Lambda]3"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Amplitude4", "\[Divide]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Omega]", "-", "\[Omega]4"}], ")"}], "*", 
               RowBox[{"-", "0.5"}], "Pi", "*", "I"}], "+", 
              RowBox[{"0.2", "*", "\[Lambda]4"}]}], ")"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], "*", "\[Phi]"}], "]"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Omega]", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Frequency (Hz)\>\"", ",", "10", ",", "Italic"}], 
          "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"330", ",", "200"}], "}"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "}"}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<One-dimensional spectroscopy\>\"", ",", " ", "\"\<Label\>\"", ",", 
     " ", "15", ",", " ", "Red", ",", " ", "Bold"}], "]"}], ",", "Delimiter", 
   ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Default Parameters\>\"", ",", 
     RowBox[{
      RowBox[{"0.25", "*", "Amplitude1"}], "=", 
      RowBox[{
       RowBox[{"0.25", "*", "Amplitude2"}], "=", 
       RowBox[{
        RowBox[{"0.25", "*", "Amplitude3"}], "=", 
        RowBox[{
         RowBox[{"0.25", "*", "Amplitude4"}], "=", 
         RowBox[{
          RowBox[{"0.25", "*", "\[Omega]1"}], "=", 
          RowBox[{
           RowBox[{"0.5", "*", "\[Omega]2"}], "=", 
           RowBox[{"\[Omega]3", "=", 
            RowBox[{
             RowBox[{"0.333", "*", "\[Omega]4"}], "=", 
             RowBox[{"\[Lambda]1", "=", 
              RowBox[{"\[Lambda]2", "=", 
               RowBox[{"\[Lambda]3", "=", 
                RowBox[{
                 RowBox[{"4", "*", "\[Lambda]4"}], "=", 
                 "1"}]}]}]}]}]}]}]}]}]}]}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}], ",", "Delimiter", 
   ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Amplitude\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude1", ",", "0.25"}], "}"}], ",", "0", ",", "5", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude2", ",", "0.25"}], "}"}], ",", "0", ",", "5", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude3", ",", "0.25"}], "}"}], ",", "0", ",", "5", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude4", ",", "0.25"}], "}"}], ",", "0", ",", "5", ",", 
     "0.25"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Frequency\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "4"}], "}"}], ",", "0", ",", "10", ",", 
     ".1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]2", ",", "2"}], "}"}], ",", "0", ",", "10", ",", 
     ".1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]3", ",", "1"}], "}"}], ",", "0", ",", "10", ",", 
     ".1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]4", ",", "3"}], "}"}], ",", "0", ",", "10", ",", 
     ".1"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Damping Rate\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]1", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]2", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]3", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]4", ",", "0.25"}], "}"}], ",", "0", ",", "2"}], "}"}],
    ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Signal Phase Shift\>\"", ",", "12", ",", "Bold"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0"}], "}"}], ",", "0", ",", 
     RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.540819382987534*^9, 3.5408194347214932`*^9}, {
  3.5408194921757793`*^9, 3.540819510915851*^9}, {3.5408195489120245`*^9, 
  3.5408195495280595`*^9}, {3.5408198897455187`*^9, 3.54081993696122*^9}, {
  3.540819972600258*^9, 3.5408199993947906`*^9}, {3.5408201937009044`*^9, 
  3.540820208632758*^9}, {3.5408216212355547`*^9, 3.540821636141407*^9}, {
  3.5408218094613204`*^9, 3.540821823121102*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Amplitude1$$ = 
    0.25, $CellContext`Amplitude2$$ = 0.25, $CellContext`Amplitude3$$ = 
    0.25, $CellContext`Amplitude4$$ = 0.25, $CellContext`\[Lambda]1$$ = 
    1, $CellContext`\[Lambda]2$$ = 1, $CellContext`\[Lambda]3$$ = 
    1, $CellContext`\[Lambda]4$$ = 0.25, $CellContext`\[Phi]$$ = 
    0, $CellContext`\[Omega]1$$ = 4, $CellContext`\[Omega]2$$ = 
    2, $CellContext`\[Omega]3$$ = 1, $CellContext`\[Omega]4$$ = 3, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["One-dimensional spectroscopy", "Label", 15, 
        RGBColor[1, 0, 0], Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Button[
       "Default Parameters", 
        0.25 $CellContext`Amplitude1$$ = (
         0.25 $CellContext`Amplitude2$$ = (
          0.25 $CellContext`Amplitude3$$ = (
           0.25 $CellContext`Amplitude4$$ = (
            0.25 $CellContext`\[Omega]1$$ = (
             0.5 $CellContext`\[Omega]2$$ = ($CellContext`\[Omega]3$$ = (
               0.333 $CellContext`\[Omega]4$$ = ($CellContext`\[Lambda]1$$ = \
($CellContext`\[Lambda]2$$ = ($CellContext`\[Lambda]3$$ = (
                   4 $CellContext`\[Lambda]4$$ = 1))))))))))), ImageSize -> 
        Large]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["Amplitude", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Amplitude1$$], 0.25}, 0, 5, 0.25}, {{
       Hold[$CellContext`Amplitude2$$], 0.25}, 0, 5, 0.25}, {{
       Hold[$CellContext`Amplitude3$$], 0.25}, 0, 5, 0.25}, {{
       Hold[$CellContext`Amplitude4$$], 0.25}, 0, 5, 0.25}, {
      Hold[
       Style["Frequency", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Omega]1$$], 4}, 0, 10, 0.1}, {{
       Hold[$CellContext`\[Omega]2$$], 2}, 0, 10, 0.1}, {{
       Hold[$CellContext`\[Omega]3$$], 1}, 0, 10, 0.1}, {{
       Hold[$CellContext`\[Omega]4$$], 3}, 0, 10, 0.1}, {
      Hold[
       Style["Damping Rate", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Lambda]1$$], 1}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]2$$], 1}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]3$$], 1}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]4$$], 0.25}, 0, 2}, {
      Hold[
       Style["Signal Phase Shift", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Phi]$$], 0}, 0, 2 Pi}}, Typeset`size$$ = {
    330., {439., 444.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`Amplitude1$4489$$ = 
    0, $CellContext`Amplitude2$4490$$ = 0, $CellContext`Amplitude3$4491$$ = 
    0, $CellContext`Amplitude4$4492$$ = 0, $CellContext`\[Omega]1$4493$$ = 
    0, $CellContext`\[Omega]2$4494$$ = 0, $CellContext`\[Omega]3$4495$$ = 
    0, $CellContext`\[Omega]4$4496$$ = 0, $CellContext`\[Lambda]1$4497$$ = 
    0, $CellContext`\[Lambda]2$4498$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Amplitude1$$ = 
        0.25, $CellContext`Amplitude2$$ = 0.25, $CellContext`Amplitude3$$ = 
        0.25, $CellContext`Amplitude4$$ = 0.25, $CellContext`\[Lambda]1$$ = 
        1, $CellContext`\[Lambda]2$$ = 1, $CellContext`\[Lambda]3$$ = 
        1, $CellContext`\[Lambda]4$$ = 0.25, $CellContext`\[Phi]$$ = 
        0, $CellContext`\[Omega]1$$ = 4, $CellContext`\[Omega]2$$ = 
        2, $CellContext`\[Omega]3$$ = 1, $CellContext`\[Omega]4$$ = 3}, 
      "ControllerVariables" :> {
        Hold[$CellContext`Amplitude1$$, $CellContext`Amplitude1$4489$$, 0], 
        Hold[$CellContext`Amplitude2$$, $CellContext`Amplitude2$4490$$, 0], 
        Hold[$CellContext`Amplitude3$$, $CellContext`Amplitude3$4491$$, 0], 
        Hold[$CellContext`Amplitude4$$, $CellContext`Amplitude4$4492$$, 0], 
        Hold[$CellContext`\[Omega]1$$, $CellContext`\[Omega]1$4493$$, 0], 
        Hold[$CellContext`\[Omega]2$$, $CellContext`\[Omega]2$4494$$, 0], 
        Hold[$CellContext`\[Omega]3$$, $CellContext`\[Omega]3$4495$$, 0], 
        Hold[$CellContext`\[Omega]4$$, $CellContext`\[Omega]4$4496$$, 0], 
        Hold[$CellContext`\[Lambda]1$$, $CellContext`\[Lambda]1$4497$$, 0], 
        Hold[$CellContext`\[Lambda]2$$, $CellContext`\[Lambda]2$4498$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Style["Free Induction Decay (Imaginary part)", "Label", 12, Bold], 
         Plot[
          
          Im[$CellContext`Amplitude1$$ 
            Exp[(($CellContext`\[Omega]1$$ Pi) I - 
               0.2 $CellContext`\[Lambda]1$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t] + \
$CellContext`Amplitude2$$ 
            Exp[((($CellContext`\[Omega]2$$ 5) Pi) I - 
               0.2 $CellContext`\[Lambda]2$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t] + \
$CellContext`Amplitude3$$ 
            Exp[((($CellContext`\[Omega]3$$ (-5)) Pi) I - (2 
                0.2) $CellContext`\[Lambda]3$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t] + \
$CellContext`Amplitude4$$ 
            Exp[((($CellContext`\[Omega]4$$ (-0.5)) Pi) I - 
               0.2 $CellContext`\[Lambda]4$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t]], {$CellContext`t, 0, 
           10}, PlotRange -> All, FrameLabel -> Style["Time (s)", 10, Italic],
           ImageSize -> {330, 200}, Frame -> True], 
         Style["Free Induction Decay (Real part)", "Label", 12, Bold], 
         Plot[
          
          Re[$CellContext`Amplitude1$$ 
            Exp[(($CellContext`\[Omega]1$$ Pi) I - 
               0.2 $CellContext`\[Lambda]1$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t] + \
$CellContext`Amplitude2$$ 
            Exp[((($CellContext`\[Omega]2$$ 5) Pi) I - 
               0.2 $CellContext`\[Lambda]2$$ - 
               
               I $CellContext`\[Phi]$$) $CellContext`t] + \
$CellContext`Amplitude3$$ 
            Exp[((($CellContext`\[Omega]3$$ (-5)) Pi) I - (2 
                0.2) $CellContext`\[Lambda]3$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t] + \
$CellContext`Amplitude4$$ 
            Exp[((($CellContext`\[Omega]4$$ (-0.5)) Pi) I - 
               0.2 $CellContext`\[Lambda]4$$ - 
               I $CellContext`\[Phi]$$) $CellContext`t]], {$CellContext`t, 0, 
           10}, PlotRange -> All, FrameLabel -> Style["Time (s)", 10, Italic],
           ImageSize -> {330, 200}, Frame -> True], 
         Style["NMR Spectrum (Imaginary part)", "Label", 12, Bold], 
         Plot[
          
          Im[($CellContext`Amplitude1$$/(
             0.2 $CellContext`\[Lambda]1$$ + (($CellContext`\[Omega] - \
$CellContext`\[Omega]1$$) Pi) I)) 
            Exp[(-I) $CellContext`\[Phi]$$] + \
($CellContext`Amplitude2$$/(((($CellContext`\[Omega] - \
$CellContext`\[Omega]2$$) 5) Pi) I + 0.2 $CellContext`\[Lambda]2$$)) 
            Exp[(-I) $CellContext`\[Phi]$$] + \
($CellContext`Amplitude3$$/(((($CellContext`\[Omega] - \
$CellContext`\[Omega]3$$) (-5)) Pi) I + 0.4 $CellContext`\[Lambda]3$$)) 
            Exp[(-I) $CellContext`\[Phi]$$] + \
($CellContext`Amplitude4$$/(((($CellContext`\[Omega] - \
$CellContext`\[Omega]4$$) (-0.5)) Pi) I + 0.2 $CellContext`\[Lambda]4$$)) 
            Exp[(-I) $CellContext`\[Phi]$$]], {$CellContext`\[Omega], 0, 10}, 
          PlotRange -> All, FrameLabel -> Style["Frequency (Hz)", 10, Italic],
           ImageSize -> {330, 200}, Frame -> True], 
         Style["NMR Spectrum (Real part)", "Label", 12, Bold], 
         Plot[
          
          Re[($CellContext`Amplitude1$$/(
             0.2 $CellContext`\[Lambda]1$$ + (($CellContext`\[Omega] - \
$CellContext`\[Omega]1$$) Pi) I)) 
            Exp[(-I) $CellContext`\[Phi]$$] + \
($CellContext`Amplitude2$$/(((($CellContext`\[Omega] - \
$CellContext`\[Omega]2$$) 5) Pi) I + 0.2 $CellContext`\[Lambda]2$$)) 
            Exp[(-I) $CellContext`\[Phi]$$] + \
($CellContext`Amplitude3$$/(((($CellContext`\[Omega] - \
$CellContext`\[Omega]3$$) (-5)) Pi) I + 0.4 $CellContext`\[Lambda]3$$)) 
            Exp[(-
               I) $CellContext`\[Phi]$$] + \
($CellContext`Amplitude4$$/(((($CellContext`\[Omega] - \
$CellContext`\[Omega]4$$) (-0.5)) Pi) I + 0.2 $CellContext`\[Lambda]4$$)) 
            Exp[(-I) $CellContext`\[Phi]$$]], {$CellContext`\[Omega], 0, 10}, 
          PlotRange -> All, FrameLabel -> Style["Frequency (Hz)", 10, Italic],
           ImageSize -> {330, 200}, Frame -> True]}], "Specifications" :> {
        Style["One-dimensional spectroscopy", "Label", 15, 
         RGBColor[1, 0, 0], Bold], Delimiter, 
        Button[
        "Default Parameters", 
         0.25 $CellContext`Amplitude1$$ = (
          0.25 $CellContext`Amplitude2$$ = (
           0.25 $CellContext`Amplitude3$$ = (
            0.25 $CellContext`Amplitude4$$ = (
             0.25 $CellContext`\[Omega]1$$ = (
              0.5 $CellContext`\[Omega]2$$ = ($CellContext`\[Omega]3$$ = (
                0.333 $CellContext`\[Omega]4$$ = ($CellContext`\[Lambda]1$$ = \
($CellContext`\[Lambda]2$$ = ($CellContext`\[Lambda]3$$ = (
                    4 $CellContext`\[Lambda]4$$ = 1))))))))))), ImageSize -> 
         Large], Delimiter, 
        Style[
        "Amplitude", 12, Bold], {{$CellContext`Amplitude1$$, 0.25}, 0, 5, 
         0.25}, {{$CellContext`Amplitude2$$, 0.25}, 0, 5, 
         0.25}, {{$CellContext`Amplitude3$$, 0.25}, 0, 5, 
         0.25}, {{$CellContext`Amplitude4$$, 0.25}, 0, 5, 0.25}, Delimiter, 
        Style[
        "Frequency", 12, Bold], {{$CellContext`\[Omega]1$$, 4}, 0, 10, 
         0.1}, {{$CellContext`\[Omega]2$$, 2}, 0, 10, 
         0.1}, {{$CellContext`\[Omega]3$$, 1}, 0, 10, 
         0.1}, {{$CellContext`\[Omega]4$$, 3}, 0, 10, 0.1}, Delimiter, 
        Style[
        "Damping Rate", 12, Bold], {{$CellContext`\[Lambda]1$$, 1}, 0, 
         2}, {{$CellContext`\[Lambda]2$$, 1}, 0, 
         2}, {{$CellContext`\[Lambda]3$$, 1}, 0, 
         2}, {{$CellContext`\[Lambda]4$$, 0.25}, 0, 2}, Delimiter, 
        Style[
        "Signal Phase Shift", 12, Bold], {{$CellContext`\[Phi]$$, 0}, 0, 2 
         Pi}}, "Options" :> {ControlPlacement -> Left}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{661., {470., 475.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({Attributes[PlotRange] = {ReadProtected}}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.540819436322585*^9, 3.540819466194293*^9}, 
   3.5408195123549337`*^9, {3.5408195455498323`*^9, 3.540819551597178*^9}, {
   3.54081989833301*^9, 3.5408199376752605`*^9}, {3.540819975552427*^9, 
   3.5408200012458963`*^9}, 3.5408202096308155`*^9, 3.540821636986456*^9, 
   3.5408216766917267`*^9, {3.540821812213478*^9, 3.540821824368173*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Attempt", " ", "at", " ", "2", "D", " ", "NMR"}]], "Input",
 CellChangeTimes->{{3.5408201210187473`*^9, 3.540820129683243*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Amplitude1a", "-", 
            RowBox[{"Amplitude1b", "*", "I"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"I", "*", "Pi", "*", "\[Omega]1"}], "-", 
              "\[Lambda]1a"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"I", "*", "5", "*", "Pi", "*", "\[Omega]2"}], "-", 
              RowBox[{"2", "*", "\[Lambda]1b"}]}], ")"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Amplitude2a", "-", 
            RowBox[{"Amplitude2b", "*", "I"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"I", "*", "Pi", "*", "\[Omega]1"}], "-", 
              "\[Lambda]2a"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"I", "*", "5", "*", "Pi", "*", "\[Omega]2"}], "-", 
              RowBox[{"2", "*", "\[Lambda]2b"}]}], ")"}]}], ")"}]}]}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[Omega]1", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Omega]2", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"500", ",", "300"}], "}"}]}]}], "]"}], "}"}], "]"}], ",", 
   "Delimiter", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude1a", ",", "0.25"}], "}"}], ",", "0", ",", "20", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude1b", ",", "0.25"}], "}"}], ",", "0", ",", "20", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude2a", ",", "0.25"}], "}"}], ",", "0", ",", "20", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Amplitude2b", ",", "0.25"}], "}"}], ",", "0", ",", "20", ",", 
     "0.25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]1a", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]1b", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]2a", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]2b", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.5406634343016024`*^9, 3.540663605551842*^9}, {
  3.5406637005219755`*^9, 3.5406638522441893`*^9}, {3.5406638866442375`*^9, 
  3.540664023988432*^9}, {3.5406640621684856`*^9, 3.5406641513506117`*^9}, {
  3.5406642347127295`*^9, 3.540664354134898*^9}, {3.540664389264947*^9, 
  3.5406644157749844`*^9}, {3.540664446735028*^9, 3.5406645058951106`*^9}, {
  3.5406645466551676`*^9, 3.540664593715234*^9}, {3.540664630375285*^9, 
  3.5406646737653456`*^9}, {3.5406647066953917`*^9, 3.5406648521175985`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Amplitude1a$$ = 
    13.5, $CellContext`Amplitude1b$$ = 13.5, $CellContext`Amplitude2a$$ = 
    13.5, $CellContext`Amplitude2b$$ = 7.5, $CellContext`\[Lambda]1a$$ = 
    0., $CellContext`\[Lambda]1b$$ = 0.85, $CellContext`\[Lambda]2a$$ = 
    1.645, $CellContext`\[Lambda]2b$$ = 0.16, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`Amplitude1a$$], 0.25}, 0, 20, 0.25}, {{
       Hold[$CellContext`Amplitude1b$$], 0.25}, 0, 20, 0.25}, {{
       Hold[$CellContext`Amplitude2a$$], 0.25}, 0, 20, 0.25}, {{
       Hold[$CellContext`Amplitude2b$$], 0.25}, 0, 20, 0.25}, {{
       Hold[$CellContext`\[Lambda]1a$$], 1}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]1b$$], 1}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]2a$$], 1}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]2b$$], 1}, 0, 2}}, Typeset`size$$ = {
    500., {147.5, 152.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`Amplitude1a$5486$$ = 
    0, $CellContext`Amplitude1b$5487$$ = 0, $CellContext`Amplitude2a$5488$$ = 
    0, $CellContext`Amplitude2b$5489$$ = 0, $CellContext`\[Lambda]1a$5490$$ = 
    0, $CellContext`\[Lambda]1b$5491$$ = 0, $CellContext`\[Lambda]2a$5492$$ = 
    0, $CellContext`\[Lambda]2b$5493$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Amplitude1a$$ = 
        0.25, $CellContext`Amplitude1b$$ = 0.25, $CellContext`Amplitude2a$$ = 
        0.25, $CellContext`Amplitude2b$$ = 0.25, $CellContext`\[Lambda]1a$$ = 
        1, $CellContext`\[Lambda]1b$$ = 1, $CellContext`\[Lambda]2a$$ = 
        1, $CellContext`\[Lambda]2b$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`Amplitude1a$$, $CellContext`Amplitude1a$5486$$, 0], 
        Hold[$CellContext`Amplitude1b$$, $CellContext`Amplitude1b$5487$$, 0], 
        Hold[$CellContext`Amplitude2a$$, $CellContext`Amplitude2a$5488$$, 0], 
        Hold[$CellContext`Amplitude2b$$, $CellContext`Amplitude2b$5489$$, 0], 
        Hold[$CellContext`\[Lambda]1a$$, $CellContext`\[Lambda]1a$5490$$, 0], 
        Hold[$CellContext`\[Lambda]1b$$, $CellContext`\[Lambda]1b$5491$$, 0], 
        Hold[$CellContext`\[Lambda]2a$$, $CellContext`\[Lambda]2a$5492$$, 0], 
        Hold[$CellContext`\[Lambda]2b$$, $CellContext`\[Lambda]2b$5493$$, 0]},
       "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Plot3D[
          
          Re[($CellContext`Amplitude1a$$ - $CellContext`Amplitude1b$$ 
             I)/(((I Pi) $CellContext`\[Omega]1 - $CellContext`\[Lambda]1a$$) \
(((I 5) Pi) $CellContext`\[Omega]2 - 
             2 $CellContext`\[Lambda]1b$$)) + ($CellContext`Amplitude2a$$ - \
$CellContext`Amplitude2b$$ 
             I)/(((I Pi) $CellContext`\[Omega]1 - $CellContext`\[Lambda]2a$$) \
(((I 5) Pi) $CellContext`\[Omega]2 - 
             2 $CellContext`\[Lambda]2b$$))], {$CellContext`\[Omega]1, 0, 
           10}, {$CellContext`\[Omega]2, 0, 10}, PlotRange -> All, 
          ImageSize -> {500, 300}]}], 
      "Specifications" :> {
       Delimiter, {{$CellContext`Amplitude1a$$, 0.25}, 0, 20, 
         0.25}, {{$CellContext`Amplitude1b$$, 0.25}, 0, 20, 
         0.25}, {{$CellContext`Amplitude2a$$, 0.25}, 0, 20, 
         0.25}, {{$CellContext`Amplitude2b$$, 0.25}, 0, 20, 
         0.25}, {{$CellContext`\[Lambda]1a$$, 1}, 0, 
         2}, {{$CellContext`\[Lambda]1b$$, 1}, 0, 
         2}, {{$CellContext`\[Lambda]2a$$, 1}, 0, 
         2}, {{$CellContext`\[Lambda]2b$$, 1}, 0, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{838., {179., 184.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.5406637588740587`*^9, 3.54066385261419*^9}, {
   3.540663887064238*^9, 3.540664024498433*^9}, {3.5406640635484877`*^9, 
   3.540664152310613*^9}, {3.5406642685627775`*^9, 3.5406643546148987`*^9}, {
   3.5406643937849536`*^9, 3.540664416854986*^9}, {3.540664479215073*^9, 
   3.5406645080051136`*^9}, {3.540664564675193*^9, 3.5406645942152343`*^9}, {
   3.5406646336952896`*^9, 3.5406646742953463`*^9}, 3.5406647757674913`*^9, {
   3.540664818577551*^9, 3.540664852757599*^9}}]
}, Open  ]]
},
WindowSize->{1350, 643},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 14025, 361, 412, "Input"],
Cell[14607, 385, 11364, 212, 962, "Output"]
}, Open  ]],
Cell[25986, 600, 151, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[26162, 606, 3361, 93, 92, "Input"],
Cell[29526, 701, 4837, 83, 380, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
